/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.config;

import cn.hutool.extra.spring.SpringUtil;
import com.mxsky.dbbackup.filter.AuthFilter;
import com.mxsky.dbbackup.listener.MxListener;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@EnableWebMvc
@EnableScheduling
@Configuration
@ComponentScan(value={"com.mxsky.dbbackup"})
@Import(value={SpringUtil.class})
public class DBBackupConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private Environment env;
    @Autowired
    private AuthFilter authFilter;

    @Bean
    public MxListener dbBackupListener() {
        return new MxListener();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/mx-ui/**"}).addResourceLocations(new String[]{"classpath:/ui/"});
    }

    @Bean
    public FilterRegistrationBean registFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.authFilter);
        registration.addUrlPatterns(new String[]{"/xjdb-backup/*"});
        registration.setName("mxAuthFilter");
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }
}

