/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.controller;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.mxsky.dbbackup.dao.DsConfigDao;
import com.mxsky.dbbackup.dao.ScheduleDao;
import com.mxsky.dbbackup.dao.TaskRecordDao;
import com.mxsky.dbbackup.dto.ScheduleDTO;
import com.mxsky.dbbackup.entity.DsConfigEntity;
import com.mxsky.dbbackup.entity.ScheduleEntity;
import com.mxsky.dbbackup.entity.TaskRecordEntity;
import com.mxsky.dbbackup.pojo.R;
import com.mxsky.dbbackup.service.AuthService;
import com.mxsky.dbbackup.service.DBBackupService;
import com.mxsky.dbbackup.service.DBRestoreService;
import com.mxsky.dbbackup.service.ScheduleService;
import com.mxsky.dbbackup.service.TaskService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/xjdb-backup"})
public class DBBackupController {
    @Autowired
    private AuthService authService;

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class, SQLException.class, RuntimeException.class})
    @ResponseBody
    public R handleError(Exception e) {
        return R.fail(e.getMessage());
    }

    @PostMapping(value={"/login"})
    @ResponseBody
    public R<String> login(String password) throws SQLException {
        return R.ok(this.authService.login(password));
    }

    @GetMapping(value={"/schedule/status"})
    @ResponseBody
    public R<Map<String, Object>> scheduleStatus() throws SQLException {
        return R.ok(ScheduleService.scheduleStatusEnum());
    }

    @PostMapping(value={"/schedule/upStatus"})
    @ResponseBody
    public R upStatus() {
        ScheduleService.updateStatus();
        return R.ok();
    }

    @PostMapping(value={"/schedule/execute"})
    @ResponseBody
    public R executeSchedule() {
        System.setProperty("TASK_RUNNING_FALG", "Y");
        ThreadUtil.execAsync((Runnable)new DBBackupService());
        return R.ok("\u6267\u884c\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u7ed3\u679c");
    }

    @PostMapping(value={"/schedule/cancelExecute"})
    @ResponseBody
    public R cancelExecuteSchedule() {
        System.setProperty("SCHEDULE_STATUS", "");
        System.setProperty("TASK_RUNNING_FALG", "N");
        return R.ok();
    }

    @PostMapping(value={"/schedule/stop"})
    @ResponseBody
    public R stopSchedule() {
        ScheduleService.stopSchedule();
        return R.ok();
    }

    @PostMapping(value={"/schedule/start"})
    @ResponseBody
    public R startSchedule() {
        ScheduleService.startSchedule();
        return R.ok();
    }

    @GetMapping(value={"/dbConfig/info"})
    @ResponseBody
    public R<DsConfigEntity> dbConfigInfo(Long dsId) throws SQLException {
        DsConfigEntity vo = DsConfigDao.info(dsId);
        vo.setPassword(null);
        return R.ok(vo);
    }

    @PostMapping(value={"/dbConfig/saveOrUpdate"})
    @ResponseBody
    public R dbConfigSaveOrUpdate(@RequestBody DsConfigEntity dto) throws SQLException {
        DsConfigDao.saveOrUpdate(dto);
        return R.ok();
    }

    @GetMapping(value={"/schedule/info"})
    @ResponseBody
    public R<ScheduleEntity> scheduleInfo(Long sId) throws SQLException {
        return R.ok(ScheduleDao.info(sId));
    }

    @PostMapping(value={"/schedule/saveOrUpdate"})
    @ResponseBody
    public R scheduleSaveOrUpdate(@RequestBody ScheduleDTO dto) throws SQLException, ParseException {
        ScheduleService.update(dto);
        return R.ok();
    }

    @GetMapping(value={"/taskRecord/list"})
    @ResponseBody
    public R<List<TaskRecordEntity>> taskRecordList() throws SQLException {
        return R.ok(TaskRecordDao.list());
    }

    @PostMapping(value={"/taskRecord/delete"})
    @ResponseBody
    public R taskRecordList(Long rId) throws SQLException {
        TaskService.deleteBackup(rId);
        return R.ok();
    }

    @RequestMapping(value={"/taskRecord/dowloadData"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public void dowloadData(Long rId, HttpServletResponse response) throws SQLException, IOException {
        TaskRecordEntity entity = TaskRecordDao.info(rId);
        if (entity == null) {
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5df2\u7ecf\u5220\u9664\u4e86");
        }
        String filename = FileNameUtil.getName((File)new File(entity.getDataFile()));
        String type = new MimetypesFileTypeMap().getContentType(filename);
        response.setHeader("Content-type", type);
        String hehe = new String(filename.getBytes("utf-8"), "iso-8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + hehe);
        FileInputStream in = new FileInputStream(entity.getDataFile());
        IoUtil.copy((InputStream)in, (OutputStream)response.getOutputStream(), (int)8192);
        in.close();
    }

    @RequestMapping(value={"/taskRecord/dowloadLog"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public void dowloadLog(Long rId, HttpServletResponse response) throws SQLException, IOException {
        TaskRecordEntity entity = TaskRecordDao.info(rId);
        if (entity == null) {
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5df2\u7ecf\u5220\u9664\u4e86");
        }
        String filename = FileNameUtil.getName((File)new File(entity.getLogFile()));
        String type = new MimetypesFileTypeMap().getContentType(filename);
        response.setHeader("Content-type", type);
        String hehe = new String(filename.getBytes("utf-8"), "iso-8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + hehe);
        FileInputStream in = new FileInputStream(entity.getLogFile());
        IoUtil.copy((InputStream)in, (OutputStream)response.getOutputStream(), (int)8192);
        in.close();
    }

    @PostMapping(value={"/dbReStore"})
    @ResponseBody
    public R dbReStore(Long rId, Boolean backup) {
        System.setProperty("TASK_RUNNING_FALG", "Y");
        ThreadUtil.execAsync((Runnable)new DBRestoreService(rId, backup));
        return R.ok("\u6267\u884c\u6210\u529f\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b\u67e5\u770b\u7ed3\u679c");
    }
}

