/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.filter;

import com.alibaba.fastjson.JSON;
import com.mxsky.dbbackup.pojo.R;
import com.mxsky.dbbackup.service.AuthService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthFilter
implements Filter {
    @Autowired
    private AuthService authService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (request.getRequestURI().contains("login") || request.getRequestURI().contains("/taskRecord/dowloadLog") || request.getRequestURI().contains("/taskRecord/dowloadData")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String token = request.getHeader("MX-TOKEN");
        if (StringUtils.isEmpty((CharSequence)token)) {
            this.response(servletResponse, R.fail(401, "\u8bf7\u767b\u5f55"));
            return;
        }
        if (!this.authService.checkToken(token)) {
            this.response(servletResponse, R.fail(401, "\u8bf7\u91cd\u65b0\u767b\u5f55\uff01"));
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    public void response(ServletResponse servletResponse, R r) throws IOException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setStatus(r.getCode());
        response.setHeader("Content-type", "textml;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(JSON.toJSONString((Object)r));
    }
}

