/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.cron.task.Task;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.mxsky.dbbackup.constants.CommonConstant;
import com.mxsky.dbbackup.controller.LogsWS;
import com.mxsky.dbbackup.dao.DsConfigDao;
import com.mxsky.dbbackup.dao.TaskRecordDao;
import com.mxsky.dbbackup.entity.DsConfigEntity;
import com.mxsky.dbbackup.entity.TaskRecordEntity;
import com.mxsky.dbbackup.enums.ScheduleStatusEnum;
import com.mxsky.dbbackup.enums.TaskStatusEnum;
import com.mxsky.dbbackup.service.DBCmdService;
import com.mxsky.dbbackup.utils.ShellExecutorUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBBackupService
implements Task,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(DBBackupService.class);

    public void execute() {
        log.info("=================\u6267\u884c\u5b9a\u65f6\u6570\u636e\u5907\u4efd=========================");
        DBBackupService.doDBBackup();
    }

    @Override
    public void run() {
        log.info("=================\u540e\u53f0\u6267\u884c\u6570\u636e\u5907\u4efd=========================");
        DBBackupService.doDBBackup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void doDBBackup() {
        block18: {
            LogsWS logsWS = (LogsWS)SpringUtil.getBean((String)"logsWS");
            StringBuilder exclogs = new StringBuilder();
            System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.RUNNING.getCode() + "");
            TimeInterval timer = DateUtil.timer();
            TaskRecordEntity entity = new TaskRecordEntity();
            entity.setrId(RandomUtil.randomLong((long)50000L));
            entity.setBackupTime(new Date());
            String publicFileName = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd_HH-mm-ss");
            String dataFile = CommonConstant.DB_DATA_PATH + publicFileName + ".sql";
            String logFile = CommonConstant.DB_DATA_PATH + publicFileName + ".log";
            logsWS.sendMessage("=================\u540e\u53f0\u6267\u884c\u6570\u636e\u5907\u4efd=========================");
            DsConfigEntity dsConfig = null;
            List<DsConfigEntity> dslist = DsConfigDao.list();
            if (dslist.size() <= 0) {
                System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.FAIL.getCode() + "");
                throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u597d\u6570\u636e\u5e93");
            }
            dsConfig = dslist.get(0);
            logsWS.sendMessage("==========================================");
            logsWS.sendMessage(" JSONObject.toJSONString(dsConfig)  " + JSONObject.toJSONString((Object)dsConfig));
            logsWS.sendMessage("dsConfig " + dsConfig.toString());
            logsWS.sendMessage("dataFile " + dataFile);
            String[] cmd = DBCmdService.getDBBackupCmd(dsConfig, dataFile);
            int i = 0;
            for (String str : cmd) {
                logsWS.sendMessage("str  " + ++i + "  " + str);
            }
            String workPath = DBCmdService.getWorkpath();
            logsWS.sendMessage("workPath " + workPath);
            int exitValue = ShellExecutorUtil.execute(cmd, workPath, null, (message, process) -> {
                try {
                    exclogs.append(message);
                    logsWS.sendMessage(message);
                    log.info(message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            log.info("exitValue: " + exitValue);
            exclogs.append("exitValue: " + exitValue);
            entity.setDataFileSize(new File(dataFile).length());
            entity.setDataFile(dataFile);
            entity.setLogFile(logFile);
            entity.setBackupDuration(timer.intervalSecond());
            entity.setStatus(TaskStatusEnum.SUCCESS.getCode());
            System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.SUCCESS.getCode() + "");
            logsWS.sendMessage("\u6570\u636e\u5e93\u5907\u4efd\u6210\u529f\uff01");
            System.setProperty("TASK_RUNNING_FALG", "N");
            BufferedOutputStream output = FileUtil.getOutputStream((String)logFile);
            IoUtil.write((OutputStream)output, (String)"UTF-8", (boolean)true, (Object[])new Object[]{exclogs.toString()});
            try {
                TaskRecordDao.saveOrUpdate(entity);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break block18;
            catch (ShellExecutorUtil.CommandTimeoutException e) {
                log.info(e.getMessage());
                exclogs.append(e.getMessage());
                System.setProperty("TASK_RUNNING_FALG", "N");
                output = FileUtil.getOutputStream((String)logFile);
                IoUtil.write((OutputStream)output, (String)"UTF-8", (boolean)true, (Object[])new Object[]{exclogs.toString()});
                try {
                    TaskRecordDao.saveOrUpdate(entity);
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e2) {
                try {
                    logsWS.sendMessage("\u6570\u636e\u5e93\u5907\u4efd\u5931\u8d25\uff01");
                    logsWS.sendMessage(e2.getMessage());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                exclogs.append(e2.getMessage());
                System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.FAIL.getCode() + "");
                entity.setBackupDuration(timer.intervalSecond());
                entity.setStatus(TaskStatusEnum.FAIL.getCode());
                {
                    catch (Throwable throwable) {
                        System.setProperty("TASK_RUNNING_FALG", "N");
                        BufferedOutputStream output2 = FileUtil.getOutputStream((String)logFile);
                        IoUtil.write((OutputStream)output2, (String)"UTF-8", (boolean)true, (Object[])new Object[]{exclogs.toString()});
                        try {
                            TaskRecordDao.saveOrUpdate(entity);
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                System.setProperty("TASK_RUNNING_FALG", "N");
                output = FileUtil.getOutputStream((String)logFile);
                IoUtil.write((OutputStream)output, (String)"UTF-8", (boolean)true, (Object[])new Object[]{exclogs.toString()});
                try {
                    TaskRecordDao.saveOrUpdate(entity);
                }
                catch (SQLException e4) {
                    e4.printStackTrace();
                }
            }
        }
    }
}

