/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.service;

import com.mxsky.dbbackup.constants.CommonConstant;
import com.mxsky.dbbackup.entity.DsConfigEntity;
import com.mxsky.dbbackup.enums.SystemOSNameEnum;
import com.mxsky.dbbackup.utils.JarUtil;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCmdService {
    private static final ThreadLocal<String> workpath = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(DBCmdService.class);

    public static String getWorkpath() {
        return workpath.get();
    }

    public static void setWorkpath(String path) {
        workpath.set(path);
    }

    public static void remove() {
        workpath.remove();
    }

    public static String[] getDBRestoreCmd(DsConfigEntity dsConfig, String dataFile) {
        if (dsConfig.getDbType().contains("mysql")) {
            return DBCmdService.getMysqlDBdbRestoreCmd(dsConfig, dataFile);
        }
        return null;
    }

    public static String[] getDBBackupCmd(DsConfigEntity dsConfig, String dataFile) {
        if (dsConfig.getDbType().contains("mysql")) {
            return DBCmdService.getMysqlDBBackupCmd(dsConfig, dataFile);
        }
        return null;
    }

    public static String[] getMysqlDBBackupCmd(DsConfigEntity dsConfig, String dataFile) {
        ArrayList<String> commands = new ArrayList<String>();
        String dbLibPath = "";
        dbLibPath = JarUtil.getSystemOsName().equals(SystemOSNameEnum.windows.getCode()) ? CommonConstant.DB_LIB_PATH + "dbProgram" + File.separator + "windows" + File.separator + dsConfig.getDbType() : CommonConstant.DB_LIB_PATH + "dbProgram" + File.separator + "linux" + File.separator + dsConfig.getDbType();
        log.info(dbLibPath);
        DBCmdService.setWorkpath(dbLibPath);
        if (JarUtil.getSystemOsName().equals(SystemOSNameEnum.windows.getCode())) {
            commands.add("cmd.exe");
            commands.add("/c");
        }
        if (JarUtil.getSystemOsName().equals(SystemOSNameEnum.windows.getCode())) {
            commands.add("mysqldump");
        }
        if (JarUtil.getSystemOsName().equals(SystemOSNameEnum.linux.getCode())) {
            commands.add("./mysqldump");
        }
        commands.add("-h" + dsConfig.getAdress());
        commands.add("-P" + dsConfig.getPort());
        commands.add("-u" + dsConfig.getUsername());
        commands.add("-p" + dsConfig.getPassword());
        if (StringUtils.isEmpty((CharSequence)dsConfig.getDatabase())) {
            commands.add("--all-databases");
        } else {
            commands.add(dsConfig.getDatabase());
        }
        commands.add("-e");
        commands.add("--single-transaction");
        commands.add("--max_allowed_packet=4194304");
        commands.add("--net_buffer_length=16384");
        commands.add("--result-file=" + dataFile);
        System.out.println(StringUtils.join((Object[])commands.toArray(), (String)" "));
        log.info(StringUtils.join((Object[])commands.toArray(), (String)" "));
        return commands.toArray(new String[commands.size()]);
    }

    public static String[] getMysqlDBdbRestoreCmd(DsConfigEntity dsConfig, String dataFile) {
        String dbLibPath = "";
        dbLibPath = JarUtil.getSystemOsName().equals(SystemOSNameEnum.windows.getCode()) ? CommonConstant.DB_LIB_PATH + "dbProgram" + File.separator + "windows" + File.separator + dsConfig.getDbType() : CommonConstant.DB_LIB_PATH + "dbProgram" + File.separator + "linux" + File.separator + dsConfig.getDbType();
        log.info(dbLibPath);
        DBCmdService.setWorkpath(dbLibPath);
        ArrayList<String> commands = new ArrayList<String>();
        if (JarUtil.getSystemOsName().equals(SystemOSNameEnum.windows.getCode())) {
            commands.add("cmd.exe");
            commands.add("/c");
        }
        if (JarUtil.getSystemOsName().equals(SystemOSNameEnum.windows.getCode())) {
            commands.add("mysql");
        }
        if (JarUtil.getSystemOsName().equals(SystemOSNameEnum.linux.getCode())) {
            commands.add("./mysql");
        }
        commands.add("-h" + dsConfig.getAdress());
        commands.add("-P" + dsConfig.getPort());
        commands.add("-u" + dsConfig.getUsername());
        commands.add("-p" + dsConfig.getPassword());
        if (StringUtils.isNotEmpty((CharSequence)dsConfig.getDatabase())) {
            commands.add(dsConfig.getDatabase());
        }
        commands.add("<" + dataFile);
        log.info(StringUtils.join((Object[])commands.toArray(), (String)" "));
        return commands.toArray(new String[commands.size()]);
    }
}

