/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.service;

import cn.hutool.extra.spring.SpringUtil;
import com.mxsky.dbbackup.controller.LogsWS;
import com.mxsky.dbbackup.dao.DsConfigDao;
import com.mxsky.dbbackup.dao.TaskRecordDao;
import com.mxsky.dbbackup.entity.DsConfigEntity;
import com.mxsky.dbbackup.entity.TaskRecordEntity;
import com.mxsky.dbbackup.enums.ScheduleStatusEnum;
import com.mxsky.dbbackup.service.DBBackupService;
import com.mxsky.dbbackup.service.DBCmdService;
import com.mxsky.dbbackup.service.ScheduleService;
import com.mxsky.dbbackup.utils.ShellExecutorUtil;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRestoreService
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DBRestoreService.class);
    private Long rId;
    private Boolean backup;

    public DBRestoreService(Long rId, Boolean backup) {
        this.rId = rId;
        this.backup = backup;
    }

    @Override
    public void run() {
        log.info("=================\u540e\u53f0\u6267\u884c\u6570\u636e\u8fd8\u539f=========================");
        ScheduleService.stopSchedule();
        DBRestoreService.doRestore(this.rId, this.backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doRestore(Long rId, Boolean backup) {
        LogsWS logsWS = (LogsWS)SpringUtil.getBean((String)"logsWS");
        try {
            if (backup.booleanValue()) {
                logsWS.sendMessage("===\u5148\u5907\u4efd\u518d\u8fd8\u539f\u6570\u636e\u5e93===");
                DBBackupService.doDBBackup();
            }
            if (rId == null) {
                throw new RuntimeException("rId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.DO_RESTORE.getCode() + "");
            DsConfigEntity dsConfig = null;
            List<DsConfigEntity> dslist = DsConfigDao.list();
            if (dslist.size() <= 0) {
                System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.RESTORE_FAIL.getCode() + "");
                throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u597d\u6570\u636e\u5e93");
            }
            dsConfig = dslist.get(0);
            TaskRecordEntity taskRecord = TaskRecordDao.info(rId);
            if (taskRecord == null) {
                throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728");
            }
            String dataFile = taskRecord.getDataFile();
            DBCmdService.getDBRestoreCmd(dsConfig, dataFile);
            String[] cmd = DBCmdService.getDBRestoreCmd(dsConfig, dataFile);
            String workPath = DBCmdService.getWorkpath();
            logsWS.sendMessage("===\u5f00\u59cb\u8fd8\u539f\u6570\u636e\u5e93===");
            int exitValue = ShellExecutorUtil.execute(cmd, workPath, null, (message, process) -> {
                log.info(message);
                logsWS.sendMessage(message);
            });
            log.info("exitValue: " + exitValue);
            System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.RESTORE_SUCCESS.getCode() + "");
        }
        catch (ShellExecutorUtil.CommandTimeoutException e) {
            try {
                logsWS.sendMessage(e.getMessage());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            log.info(e.getMessage());
        }
        catch (Exception e) {
            try {
                logsWS.sendMessage(e.getMessage());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.setProperty("SCHEDULE_STATUS", ScheduleStatusEnum.RESTORE_FAIL.getCode() + "");
        }
        finally {
            ScheduleService.startSchedule();
            System.setProperty("TASK_RUNNING_FALG", "N");
        }
    }
}

