/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.service;

import cn.hutool.core.io.IoUtil;
import com.mxsky.dbbackup.constants.H2DataBaseConstant;
import com.mxsky.dbbackup.utils.JarUtil;
import java.io.InputStream;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.h2.jdbcx.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DataBaseService {
    private static final Logger log = LoggerFactory.getLogger(H2DataBaseService.class);

    public static void init() throws Exception {
        JdbcDataSource ds = H2DataBaseService.getDataSource();
        if (H2DataBaseService.isFristStart((DataSource)ds)) {
            H2DataBaseService.createDatabase((DataSource)ds);
        }
    }

    public static JdbcDataSource getDataSource() {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(H2DataBaseConstant.URL);
        ds.setUser("sa");
        ds.setPassword("");
        return ds;
    }

    public static void createDatabase(DataSource ds) throws Exception {
        InputStream in = JarUtil.getInputStream(H2DataBaseService.class, "db/V1.0__init.sql");
        String sqltext = IoUtil.read((InputStream)in, (String)"UTF-8");
        String[] sqls = sqltext.split(";");
        QueryRunner run = new QueryRunner(ds);
        for (String sql : sqls) {
            run.update(sql);
        }
    }

    public static boolean isFristStart(DataSource ds) throws Exception {
        try {
            String sql = "SELECT * FROM DB_TYPE DB_TYPE";
            QueryRunner qr = new QueryRunner(ds);
            qr.query(sql, (ResultSetHandler)new ArrayHandler());
        }
        catch (SQLException e) {
            return true;
        }
        return false;
    }
}

