/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MySQLBackup {
    private static String user = "root";
    private static String password = "root";
    private static String database;
    private static String host;
    private static String port;
    private static String charsetName;
    private static String mysqlPath;
    private static String EXPORT_BASE_PATH;
    private static String BAKUP_FOLDER;
    private static String exportPath;
    private static String osName;
    private static String fileName;
    private static SimpleDateFormat dateFormat;
    private static Logger logger;

    public static void backupAndSave(String springResourcePath) {
        try {
            MySQLBackup.initByApplication(springResourcePath);
            MySQLBackup.doBackUpAndSave();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0cXML\u89e3\u6790\u5668\u521b\u5efa\u5931\u8d25\uff01");
        }
        catch (SAXException e) {
            logger.error((Object)"MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0cXML\u89e3\u6790\u9519\u8bef\uff01");
        }
        catch (IOException e) {
            logger.error((Object)"MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0cXML\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }

    public static void backupAndSave(String user, String password, String database, String host, String port, String charsetName, String mysqlPath, String exportPath) {
        MySQLBackup.initByCustomer(user, password, database, host, port, charsetName, mysqlPath, exportPath);
        MySQLBackup.doBackUpAndSave();
    }

    private static void initByApplication(String springResourcePath) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputStream resourceAsStream = null;
        Document document = null;
        resourceAsStream = MySQLBackup.class.getClassLoader().getResourceAsStream(springResourcePath);
        document = documentBuilder.parse(resourceAsStream);
        NodeList beanNodeList = document.getElementsByTagName("bean");
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (int i = 0; i < beanNodeList.getLength(); ++i) {
            Node beanNode = beanNodeList.item(i);
            Element bean = (Element)beanNode;
            if (!"dataSource".equals(bean.getAttribute("id"))) continue;
            NodeList nodeList = bean.getElementsByTagName("property");
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element propertyNode = (Element)nodeList.item(j);
                String name = propertyNode.getAttribute("name");
                String value = propertyNode.getAttribute("value");
                propertiesMap.put(name, value);
            }
            break;
        }
        user = (String)propertiesMap.get("user");
        password = (String)propertiesMap.get("password");
        String jdbcUrl = (String)propertiesMap.get("jdbcUrl");
        String hostAndPort = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2, jdbcUrl.lastIndexOf("/"));
        if (hostAndPort.length() != 0 && hostAndPort.contains(":")) {
            String connectPort;
            String connectHost = hostAndPort.substring(0, hostAndPort.lastIndexOf(":"));
            if (connectHost != "") {
                host = connectHost;
            }
            if ((connectPort = hostAndPort.substring(hostAndPort.lastIndexOf(":") + 1)) != "") {
                port = connectPort;
            }
        }
        int databaseLastIndex = -1;
        databaseLastIndex = jdbcUrl.indexOf("?");
        database = databaseLastIndex != -1 ? jdbcUrl.substring(jdbcUrl.lastIndexOf("/") + 1, databaseLastIndex) : jdbcUrl.substring(jdbcUrl.lastIndexOf("/") + 1);
        int charsetNameFromIndex = -1;
        charsetNameFromIndex = jdbcUrl.indexOf("characterEncoding");
        if (charsetNameFromIndex != -1) {
            int charsetNameLastIndex = jdbcUrl.indexOf("&", charsetNameFromIndex = charsetNameFromIndex + "characterEncoding".length() + 1);
            if (charsetNameLastIndex != -1) {
                charsetName = jdbcUrl.substring(charsetNameFromIndex, charsetNameLastIndex);
            } else if (jdbcUrl.substring(charsetNameFromIndex) != "") {
                charsetName = jdbcUrl.substring(charsetNameFromIndex);
            }
        }
    }

    private static void initByCustomer(String user, String password, String database, String host, String port, String charsetName, String mysqlPath, String exportPath) {
        if (user != null && user.length() != 0) {
            MySQLBackup.user = user;
        }
        if (password != null && password.length() != 0) {
            MySQLBackup.password = password;
        }
        if (database != null && database.length() != 0) {
            MySQLBackup.database = database;
        }
        if (host != null && host.length() != 0) {
            MySQLBackup.host = host;
        }
        if (port != null && port.length() != 0) {
            MySQLBackup.port = port;
        }
        if (charsetName != null && charsetName.length() != 0) {
            MySQLBackup.charsetName = charsetName;
        }
        if (mysqlPath != null && mysqlPath.length() != 0) {
            MySQLBackup.mysqlPath = mysqlPath + File.separator + "bin" + File.separator;
        }
        if (exportPath != null && exportPath.length() != 0) {
            MySQLBackup.exportPath = exportPath;
        }
    }

    private static void doBackUpAndSave() {
        fileName = dateFormat.format(new Date()) + ".sql";
        File file = new File(exportPath);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            file.delete();
            file.mkdirs();
        }
        File exportFile = new File(exportPath + fileName);
        if (exportFile.exists()) {
            exportFile.delete();
        }
        try {
            exportFile.createNewFile();
        }
        catch (IOException e1) {
            logger.error((Object)("MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c" + exportPath + fileName + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff01"));
        }
        String mysqldump = "";
        mysqldump = osName.startsWith("Windows") ? "cmd /c \"" + mysqlPath + "mysqldump\"" : mysqlPath + "mysqldump";
        String command = new StringBuffer(mysqldump).append(" -u").append(user).append(" -p").append(password).append(" -h").append(host).append(" -P").append(port).append(" --default-character-set=").append(charsetName).append(" -B ").append(database).append(" -r").append(exportPath + fileName).toString();
        logger.info((Object)("\nMySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff1a\n\tuser:" + user + "\n\tpassword:" + password + "\n\thost:" + host + "\n\tport:" + port + "\n\tdatabase:" + database + "\n\texportPath:" + exportPath));
        try {
            MySQLBackup.doBackup(command);
            MySQLBackup.doSave();
        }
        catch (IOException e) {
            logger.error((Object)("MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c\u5907\u4efd\u547d\u4ee4\u6267\u884c\u9519\u8bef\uff01" + e.getMessage()));
        }
    }

    private static void doBackup(String command) throws IOException {
        logger.info((Object)("MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c\u547d\u4ee4\u4e3a\uff1a" + command));
        Runtime runtime = Runtime.getRuntime();
        Process exec = runtime.exec(command);
        try {
            exec.waitFor();
        }
        catch (InterruptedException e) {
            logger.error((Object)"MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c\u547d\u4ee4\u6ca1\u6709\u6b63\u5e38\u9000\u51fa\uff01");
        }
    }

    private static void doSave() throws IOException {
        File exportFile = new File(exportPath + fileName);
        FileInputStream inputStream = new FileInputStream(exportFile);
        String fileStr = exportPath + fileName.substring(0, fileName.lastIndexOf("."));
        if (osName.startsWith("Windows")) {
            fileStr = fileStr + ".zip";
            logger.info((Object)("MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c\u5907\u4efd\u8def\u5f84\u4e3a\uff1a" + fileStr));
            try {
                MySQLBackup.saveAsZip(inputStream, fileStr);
            }
            catch (Exception e) {
                logger.error((Object)"MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c\u751f\u6210\u5907\u4efd\u6587\u4ef6\u5931\u8d25\uff01");
            }
        } else {
            fileStr = fileStr + ".gz";
            logger.info((Object)("MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c\u5907\u4efd\u8def\u5f84\u4e3a\uff1a" + fileStr));
            try {
                MySQLBackup.saveAsGZip(inputStream, fileStr);
            }
            catch (Exception e) {
                logger.error((Object)"MySQL\u6570\u636e\u5e93\u8fdb\u884c\u5907\u4efd\uff0c\u751f\u6210\u5907\u4efd\u6587\u4ef6\u5931\u8d25\uff01");
            }
        }
        inputStream.close();
        exportFile.delete();
    }

    private static void saveAsZip(FileInputStream inputStream, String fileStr) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileStr);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        byte[] b = new byte[1024];
        int length = 0;
        zipOutputStream.putNextEntry(new ZipEntry(fileName));
        while ((length = inputStream.read(b)) != -1) {
            zipOutputStream.write(b, 0, length);
        }
        zipOutputStream.closeEntry();
        zipOutputStream.finish();
        zipOutputStream.flush();
        zipOutputStream.close();
        fileOutputStream.close();
    }

    private static void saveAsGZip(FileInputStream inputStream, String fileStr) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileStr);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
        byte[] b = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(b)) != -1) {
            gzipOutputStream.write(b, 0, length);
        }
        gzipOutputStream.finish();
        gzipOutputStream.flush();
        gzipOutputStream.close();
        fileOutputStream.close();
    }

    static {
        host = "localhost";
        port = "3306";
        charsetName = "utf8";
        mysqlPath = "";
        EXPORT_BASE_PATH = "/home/" + System.getProperty("user.name");
        BAKUP_FOLDER = "/backup/mysql/";
        exportPath = EXPORT_BASE_PATH + BAKUP_FOLDER;
        osName = System.getProperty("os.name");
        dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        logger = Logger.getLogger(MySQLBackup.class);
    }
}

