/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import com.mxsky.dbbackup.dao.ScheduleDao;
import com.mxsky.dbbackup.dto.ScheduleDTO;
import com.mxsky.dbbackup.entity.ScheduleEntity;
import com.mxsky.dbbackup.enums.ScheduleStatusEnum;
import com.mxsky.dbbackup.service.DBBackupService;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;

public class ScheduleService {
    public static void init() {
        ScheduleService.stopSchedule();
        try {
            List<ScheduleEntity> taskList = ScheduleDao.list();
            for (ScheduleEntity task : taskList) {
                CronUtil.getScheduler().clear();
                System.setProperty("SCHEDULE_CRON", task.getCron());
                String id = CronUtil.schedule((String)(task.getsId() + ""), (String)task.getCron(), (Task)new DBBackupService());
                System.setProperty("SCHEDULE_ID", id);
                CronUtil.setMatchSecond((boolean)true);
                CronUtil.start((boolean)true);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u5b9a\u65f6\u4efb\u52a1\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
    }

    public static boolean status() {
        return CronUtil.getScheduler().isStarted();
    }

    public static Map<String, Object> scheduleStatusEnum() throws SQLException {
        String statusId;
        Map<Object, Object> res = new HashMap();
        boolean status = ScheduleService.status();
        if (status) {
            res = ScheduleStatusEnum.getMap(ScheduleStatusEnum.ENABLE.getCode());
            String msg = (String)res.get("msg");
            Date date = ScheduleService.getNextTriggerTime(System.getProperty("SCHEDULE_CRON"));
            msg = msg + "<br>\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)date);
            res.put("msg", msg);
        } else {
            res = ScheduleStatusEnum.getMap(ScheduleStatusEnum.DISABLE.getCode());
        }
        List<ScheduleEntity> dsList = ScheduleDao.list();
        if (dsList.size() == 0) {
            res = ScheduleStatusEnum.getMap(ScheduleStatusEnum.NOREADY.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)(statusId = System.getProperty("SCHEDULE_STATUS")))) {
            int statusID = Integer.parseInt(statusId);
            res = ScheduleStatusEnum.getMap(statusID);
        }
        return res;
    }

    public static void stopSchedule() {
        if (CronUtil.getScheduler().isStarted()) {
            CronUtil.stop();
            CronUtil.getScheduler().clear();
        }
    }

    public static void startSchedule() {
        ScheduleService.init();
    }

    public static void updateStatus() {
        System.setProperty("SCHEDULE_STATUS", "");
    }

    public static void update(ScheduleDTO dto) throws SQLException, ParseException {
        if (StringUtils.isEmpty((CharSequence)dto.getCron())) {
            throw new RuntimeException("cron\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getDsId() == null) {
            throw new RuntimeException("dsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScheduleEntity entity = new ScheduleEntity();
        BeanUtil.copyProperties((Object)dto, (Object)((Object)entity), (String[])new String[0]);
        ScheduleDao.saveOrUpdate(entity);
        ScheduleService.init();
    }

    public static Date getNextTriggerTime(String cron) {
        if (!CronExpression.isValidExpression((String)cron)) {
            throw new RuntimeException("cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("Caclulate Date").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
        Date time0 = trigger.getStartTime();
        Date time1 = trigger.getFireTimeAfter(time0);
        return time1;
    }
}

