/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.utils;

import cn.hutool.core.io.resource.ResourceUtil;
import com.mxsky.dbbackup.enums.SystemOSNameEnum;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;

public class JarUtil {
    public static String getJarPathFromLib(Class cls) {
        URL url = cls.getProtectionDomain().getCodeSource().getLocation();
        String path = url.getFile();
        if (System.getProperty("os.name").contains("dows") && path.indexOf("/") == 0) {
            path = path.substring(path.indexOf("/") + 1, path.length());
        }
        return path;
    }

    public static int getRunEnviron(Class cls) {
        String path = cls.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path.contains(".jar")) {
            if (path.contains("!/")) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static String getDPJarName(Class cls) {
        String path = cls.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path.contains("!/")) {
            String[] jars = path.split("!/");
            if (jars.length == 2) {
                path = jars[1];
                path = path.substring(path.lastIndexOf("/") + 1, path.length());
            } else {
                throw new RuntimeException("\u4e0d\u7b26\u5408 jar\u6a21\u5f0f\u8fd0\u884c,lib\u653e\u5728jar\u91cc\u9762");
            }
        }
        return path;
    }

    public static String getJarFilePath(Class cls) {
        URL url = cls.getProtectionDomain().getCodeSource().getLocation();
        String path = url.getFile();
        if (path.contains("!/")) {
            path = path.substring(path.indexOf("/"), path.length());
        }
        if (path.indexOf("!") > -1) {
            path = path.substring(0, path.indexOf("!"));
        }
        if (System.getProperty("os.name").contains("dows") && path.indexOf("/") == 0) {
            path = path.substring(path.indexOf("/") + 1, path.length());
        }
        return path;
    }

    public static InputStream getJarInputStream(String jarFilePath, String name) throws Exception {
        JarFile jarFile = new JarFile(new File(jarFilePath));
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(name)) continue;
            return jarFile.getInputStream(jarFile.getEntry(entryName));
        }
        throw new Exception(jarFilePath + "\u91cc\u627e\u4e0d\u5230" + name + "\u6587\u4ef6");
    }

    public static InputStream getInputStream(Class cls, String fileName) {
        try {
            String workSpace = System.getProperty("user.dir") + File.separator + "dbSupport" + File.separator;
            File runPathFile = new File(workSpace);
            if (!runPathFile.exists()) {
                runPathFile.mkdirs();
            }
            switch (JarUtil.getRunEnviron(cls)) {
                case 0: {
                    InputStream in = ResourceUtil.getStream((String)fileName);
                    return in;
                }
                case 1: {
                    String libJarFile = JarUtil.getJarPathFromLib(cls);
                    InputStream libJarInputSt = JarUtil.getJarInputStream(libJarFile, fileName);
                    return libJarInputSt;
                }
                case 2: {
                    String jarFilePath = JarUtil.getJarFilePath(cls);
                    String dependentJarName = JarUtil.getDPJarName(cls);
                    String dependentJarFile = workSpace + dependentJarName;
                    InputStream inputSt = JarUtil.getJarInputStream(jarFilePath, dependentJarName);
                    FileUtils.copyInputStreamToFile((InputStream)inputSt, (File)new File(dependentJarFile));
                    inputSt.close();
                    InputStream jarInputSt = JarUtil.getJarInputStream(dependentJarFile, fileName);
                    return jarInputSt;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getSystemOsName() {
        if (System.getProperty("os.name").contains("dows")) {
            return SystemOSNameEnum.windows.getCode();
        }
        return SystemOSNameEnum.linux.getCode();
    }
}

