/*
 * Decompiled with CFR 0.152.
 */
package com.mxsky.dbbackup.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellExecutorUtil {
    private static Logger logger = LoggerFactory.getLogger(ShellExecutorUtil.class);
    private static ExecutorService communicatorExecutor = Executors.newCachedThreadPool();

    public static int execute(String[] command, String directory, Long timeout, Communicator ... communicators) throws CommandTimeoutException {
        int status;
        block7: {
            File workDir;
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (directory != null && (workDir = new File(directory)).exists() && workDir.isDirectory()) {
                processBuilder.directory(workDir);
            }
            processBuilder.redirectErrorStream(true);
            status = -1;
            try {
                Process process = processBuilder.start();
                if (communicators != null && communicators.length > 0) {
                    communicatorExecutor.submit(() -> {
                        BufferedReader reader = null;
                        try {
                            String line;
                            InputStream inputStream = process.getInputStream();
                            if (inputStream == null) {
                                return;
                            }
                            reader = new BufferedReader(new InputStreamReader(inputStream));
                            while ((line = reader.readLine()) != null) {
                                for (Communicator communicator : communicators) {
                                    communicator.onMessage(line, process);
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Exception e) {
                                    logger.warn(e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    });
                }
                if (timeout == null || timeout <= 0L) {
                    status = process.waitFor();
                } else {
                    if (!process.waitFor(timeout, TimeUnit.MILLISECONDS)) {
                        throw new CommandTimeoutException(String.format("Command execute timeout, timeout: %s, command: %s", timeout, command));
                    }
                    status = process.exitValue();
                }
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (!(e instanceof CommandTimeoutException)) break block7;
                throw (CommandTimeoutException)e;
            }
        }
        return status;
    }

    public static interface Communicator {
        public void onMessage(String var1, Process var2) throws IOException;
    }

    public static class CommandTimeoutException
    extends Exception {
        public CommandTimeoutException(String message) {
            super(message);
        }
    }
}

